using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Items;
using Server.Mobiles;
using Server.Commands;
using Server.Engines.XmlSpawner2;

namespace Server.Gumps
{
	public class KingGumpEnd : Gump
	{
		private Mobile m_King;
		private Mobile m_From;
		private HlavniQuest m_Quest;
		
		public KingGumpEnd( Mobile king, Mobile from ) : base( 50,50 )
		{
			m_King = king;
			m_From = from;
			m_Quest = (HlavniQuest)XmlAttach.FindAttachment(m_From,typeof(HlavniQuest));
			//----------------------------------------------------------------------------------------------------

			AddPage( 0 );
			AddImageTiled(  54, 33, 369, 400, 2624 );
			AddAlphaRegion( 54, 33, 369, 400 );

			AddImageTiled( 416, 39, 44, 389, 203 );
			//--------------------------------------Window size bar--------------------------------------------
			
			AddImage( 97, 49, 9004 );
			AddImageTiled( 58, 39, 29, 390, 10460 );
			AddImageTiled( 412, 37, 31, 389, 10460 );
			AddLabel( 140, 60, 1152, "Kral Artur" );
			AddImage( 430, 9, 10441);
			AddImageTiled( 40, 38, 17, 391, 9263 );
			AddImage( 6, 25, 10421 );
			AddImage( 34, 12, 10420 );
			AddImageTiled( 94, 25, 342, 15, 10304 );
			AddImageTiled( 40, 427, 415, 16, 10304 );
			AddImage( -10, 314, 10402 );
			AddImage( 56, 150, 10411 );
			// 			AddImage( 155, 120, 2103 );
			AddImage( 136, 84, 96 );
			
			AddButton( 107, 384, 2224, 2224, 1, GumpButtonType.Reply, 0 );
			AddLabel(130, 380, 1152, @"Vezmu si tuto odmenu.");
			AddButton( 107, 404, 2224, 2224, 0, GumpButtonType.Reply, 0 );
			AddLabel(130, 400, 1152, @"Prijdu si pro odmenu pozdeji.");
			
			AddPage( 1 );
			AddHtml( 107, 120, 300, 70, "<BODY>" +
			        "<BASEFONT COLOR=YELLOW>Skvele, ani sem neveril ze to dokazes. Nase zeme ti bude navzdy vdecna za zachranu.<br>Jak jsem slibil, zde je tva odmena. Vyber si jeden z nasledujicich predmetu." +
			        "<br>Pokud si je chces prohlednout, muzes navstivit muzeum nedaleko hlavni banky.</BODY>", false, true);
			
			AddButton( 107, 202, 9763, 9762, 0, GumpButtonType.Page, 2 );
			AddLabel(130, 200, 1152, @"Armor of Virtues");
			AddRadio( 107, 222, 210, 211, false, 100 );
			AddLabel(130, 220, 1152, @"Ultimate Quiver");
			
			if ( m_Quest != null )
			{
            AddRadio( 107, 242, 210, 211, false, 101 );
				AddLabel(130, 240, 1152, @"Scroll of Power " + PSValue( m_Quest.Count ).ToString() + " Maximum Stats" );
            AddRadio( 107, 262, 210, 211, false, 103 );
            AddLabel(130, 260, 1152, @"Balicek magickych dratu a svitku" );
            
            if ( m_Quest.Count > 3 )
                AddRadio( 107, 282, 210, 211, false, 102 );
                
             AddLabel(130, 280, 1152, @"Barva na kuzi (3 pouziti)" );
             
            if ( !PlayerTitles.HasTitle( m_From, 0 ) )
                AddRadio( 107, 302, 210, 211, false, 104 );
             
            AddLabel(130, 300, 1152, @"Titul " + PlayerTitles.TitleName[0] );
               
            if ( m_Quest.Count > 9 && !PlayerTitles.HasTitle( m_From, 1 ) )
                AddRadio( 107, 322, 210, 211, false, 105 );
             
            AddLabel(130, 320, 1152, @"Titul " + PlayerTitles.TitleName[1] );
            
            AddRadio( 107, 342, 210, 211, false, 106 );
            AddLabel(130, 340, 1152, @"5 stat scrollu +1" );
         }
			
			AddPage( 2 );
			AddLabel(107, 120, 0x34, @"Armor of Virtues");
			AddRadio( 107, 153, 210, 211, false, 200 );
			AddLabel(130, 151, 1152, @"Arms of Compassion & Legs of Honor");
			AddRadio( 107, 173, 210, 211, false, 201 );
			AddLabel(130, 171, 1152, @"Cloak of Humility & Solarets of Sacrifice");
			AddRadio( 107, 193, 210, 211, false, 202 );
			AddLabel(130, 191, 1152, @"Dupre's Shield & Gauntlets of Valor");
			AddRadio( 107, 213, 210, 211, false, 203 );
			AddLabel(130, 211, 1152, @"Helm of Spirituality & Gorget of Truth");
			AddRadio( 107, 233, 210, 211, false, 204 );
			AddLabel(130, 231, 1152, @"Breastplate of Justice");

			if ( m_Quest != null && m_Quest.Count > 4 )
			{
			   AddRadio( 107, 260, 210, 211, false, 205 );
			   AddLabel(130, 258, 1152, @"Scroll of Virtue x2");
			   
            if ( HasFullSet( m_From ) && !PlayerTitles.HasTitle( m_From, 24 ) )
               AddRadio( 107, 280, 210, 211, false, 206 );
               
			   AddLabel(130, 278, 1152, @"Titul " + PlayerTitles.TitleName[24]);
			   
            if ( HasFullSet( m_From ) )
               AddRadio( 107, 300, 210, 211, false, 207 );
               
			   AddLabel(130, 298, 1152, @"Knight's Ring");			   
         }

			AddButton( 225, 360, 2322, 2323, 0, GumpButtonType.Page, 1 ); //zpet na prvni stranku
		}
		
		private static bool HasFullSet( Mobile from )
		{
         Item shield = from.FindItemOnLayer( Layer.TwoHanded );
         Item boots = from.FindItemOnLayer( Layer.Shoes );
         Item cloak = from.FindItemOnLayer( Layer.Cloak );
         
         if ( !( from.HandArmor is GauntletsOfValor && ((GauntletsOfValor)from.HandArmor).Bonus > 4 && ((Item)from.HandArmor).BlessedFor == from ) )
            return false;
         else if ( !( from.ArmsArmor is ArmsOfCompassion && ((ArmsOfCompassion)from.ArmsArmor).Bonus > 4 && ((Item)from.ArmsArmor).BlessedFor == from ) )
            return false;
         else if ( !( from.HeadArmor is HelmOfSpirituality && ((HelmOfSpirituality)from.HeadArmor).Bonus > 4 && ((Item)from.HeadArmor).BlessedFor == from ) )
            return false;
         else if ( !( from.LegsArmor is LegsOfHonor && ((LegsOfHonor)from.LegsArmor).Bonus > 4 && ((Item)from.LegsArmor).BlessedFor == from ) )
            return false;
         else if ( !( from.ChestArmor is PlateOfJustice && ((PlateOfJustice)from.ChestArmor).Bonus > 4 && ((Item)from.ChestArmor).BlessedFor == from ) )
            return false;
         else if ( !( from.NeckArmor is GorgetOfTruth && ((GorgetOfTruth)from.NeckArmor).Bonus > 4 && ((Item)from.NeckArmor).BlessedFor == from ) )
            return false;
         else if ( !( shield is DupresShield && ((DupresShield)shield).Bonus > 4 && shield.BlessedFor == from ) )
            return false;
         else if ( !( boots is SolaretsOfSacrifice && ((SolaretsOfSacrifice)boots).Bonus > 4 && boots.BlessedFor == from ) )
            return false;
         else if ( !( cloak is CloakOfHumility && ((CloakOfHumility)cloak).Bonus > 4 && cloak.BlessedFor == from ) )
            return false;
         else
            return true;
      }

		public override void OnResponse( NetState state, RelayInfo info )
		{
			m_From = state.Mobile;

			switch ( info.ButtonID )
			{
				case 0:
					{
						m_King.Say( "Dobra, dvere jsou ti kdykoliv otevreny." );
						break;
					}
				case 1:
					{
						bool selected = false;
						
						if ( m_Quest == null )
							m_From.SendMessage( 34, "Neocekavana chyba, kontaktuj Game mastera! #1");
						else if ( info.Switches.Length < 1 )
							m_From.SendMessage( "Stale jsi si nevybral(a) odmenu, prijd tedy pozdeji!");
						else
						{
							Container bag = new Bag();
							bag.Hue = 1151;
							Item reward = null;
							Item reward2 = null;
							
							if ( info.Switches.Length == 1 && info.IsSwitched( 100 ) )
							{
								selected = true;
								reward = new UltimateQuiver();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 101 ) )
							{
								selected = true;
								reward = new StatCapScroll( PSValue( m_Quest.Count ) );
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 102 ) )
							{
								selected = true;
								reward = new AllDyeTubsSkin();
								((AllDyeTubsSkin)reward).Charges = 3;
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 103 ) )
							{
								selected = true;
                        bag.DropItem( new MesicniKamen( 6 ) );
                        bag.DropItem( new MagicalWire( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicalWire( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicalWire( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicalWire( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicalWire( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicScroll( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicScroll( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new MagicScroll( Utility.RandomMinMax( 1, 3 ) ) );
                        bag.DropItem( new AuberonuvZub() );
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 104 ) )
							{
								selected = true;
								PlayerTitles.AddTitle( m_From, 0 );
								m_From.Title = PlayerTitles.TitleName[ 0 ];
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 105 ) )
							{
								selected = true;
								PlayerTitles.AddTitle( m_From, 1 );
								m_From.Title = PlayerTitles.TitleName[ 1 ];
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 106 ) )
							{
								selected = true;								
								
								for (int i = 0; i < 5; i++)
								{
                           Item scr = new StatScroll( 1 );
                           scr.BlessedFor = m_From;
                           scr.Hue = 2614;
                           bag.DropItem( scr );
                        }
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 200 ) )
							{
								selected = true;
								reward = new ArmsOfCompassion();
								reward2 = new LegsOfHonor();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 201 ) )
							{
								selected = true;
								reward = new CloakOfHumility();
								reward2 = new SolaretsOfSacrifice();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 202 ) )
							{
								selected = true;
								reward = new DupresShield();
								reward2 = new GauntletsOfValor();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 203 ) )
							{
								selected = true;
								reward = new HelmOfSpirituality();
								reward2 = new GorgetOfTruth();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 204 ) )
							{
								selected = true;
								reward = new PlateOfJustice();
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 205 ) )
							{
								selected = true;
								reward = new ScrollOfVirtue( 2 );
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 206 ) )
							{
								selected = true;
								PlayerTitles.AddTitle( m_From, 24 );
								m_From.Title = PlayerTitles.TitleName[ 24 ];
							}
							else if ( info.Switches.Length == 1 && info.IsSwitched( 207 ) && HasFullSet( m_From ) )
							{
								selected = true;
								reward = new KnightsRing();
							}
							
							
							if ( selected )
							{
								m_Quest.NextRepeat = DateTime.Now + TimeSpan.FromDays( 7.0 );
								m_Quest.KilledDragon = false;
								m_Quest.InProgress = false;
								m_Quest.Count++;
								
								bag.DropItem( new Tokens( 100 ) );
								bag.DropItem( new BankCheck( 50000 ) );
								
								if ( reward != null )
								{
									if ( !( reward is ScrollOfVirtue ) )
                              reward.BlessedFor = m_From;
                              
									reward.LootType = LootType.Blessed;									   
                           bag.DropItem( reward );
                        }
								                        
                        if ( reward2 != null )
								{
									reward2.BlessedFor = m_From;
									reward2.LootType = LootType.Blessed;
                           bag.DropItem( reward2 );
                        }
								
								m_From.AddToBackpack( bag );
								Guilds.Guild.GiveXp( m_From, 25000 );
								m_King.Say( "Zde je tva odmena rytiri" );
								m_From.Fame = 15000;
								m_From.SendMessage( 34, "Blahoprejeme, quest byl dokoncen. Dalsi opakovani je mozne az po sedmi dnech!" );
							}
							else
								m_From.SendMessage( 34, "Neocekavana chyba, kontaktuj Game mastera! #2");
						}
						break;
					}
			}
		}
		
		private static int PSValue( int val )
		{
			int r = 305;
			
			if ( val > 0 )
			   r += ( val * 5 );

         return ( r > 350 ) ? 350 : r;
		}
	}
}
